/******************************************************************************\
**
**     COMPANY:	LDW Software
**
**      MODULE:	Smoke
**
** DESCRIPTION:	Manages a number of smoke emitters
**
**      AUTHOR:	Adrian Francis
**
\******************************************************************************/

#ifndef SMOKE_H
#define SMOKE_H

/******************************************************************************\
** LIBRARY INCLUDES
\******************************************************************************/
#include "ldwTypes.h"
#include "FloatingAnim.h"
#include "../Villagers/VillagerAttachmentInterface.h"

/******************************************************************************\
** CONSTANT DEFINITIONS
\******************************************************************************/
const int Smoke_c_iMaxEmitters = 16;

/******************************************************************************\
** CLASS DEFINITIONS
\******************************************************************************/
class CSmoke : public IVillagerAttachment
{
private:

	//class structures
	struct SEmitter
	{
		bool			m_bIsActive;
		ldwPoint		m_sPos;
		int				m_iIntensity;
		EFloatingAnim	m_eFloatingAnim;
		int				m_iPoofs;
		unsigned int	m_uiTimer;
	};

	//class data
	SEmitter			m_sEmitter[Smoke_c_iMaxEmitters];

	//class methods
	//setup
	public:		CSmoke(void);
	public:		void Reset();

	// process
	public:		const int Add(const ldwPoint sPos, const int iIntensity, const EFloatingAnim eFloatingAnim = eFloatingAnim_Smoke, const int iPoofs = 0);
	public:		void Remove(const int iEmitter);

	public:		void Update();

	// access
	public:		void SetPos(const int iEmitter, const ldwPoint sPos);
	public:		void SetIntensity(const int iEmitter, const int iIntensity);
};

/******************************************************************************\
** GLOBAL DECLARATIONS
\******************************************************************************/
extern CSmoke		Smoke;

#endif

/******************************************************************************\
** END OF FILE
\******************************************************************************/